/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetSacrifice;

class JaradGolgariLichLordTarget
extends TargetSacrifice {
    private static final FilterPermanent filter = new FilterPermanent("a Swamp and a Forest");
    private static final SubTypeAssignment subtypeAssigner;

    JaradGolgariLichLordTarget() {
        super(2, 2, filter);
    }

    private JaradGolgariLichLordTarget(JaradGolgariLichLordTarget target) {
        super((TargetSacrifice)target);
    }

    public JaradGolgariLichLordTarget copy() {
        return new JaradGolgariLichLordTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Set permanents = this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        permanents.add(game.getPermanent(id));
        return subtypeAssigner.getRoleCount(permanents, game) >= permanents.size();
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.SWAMP.getPredicate(), (Predicate)SubType.FOREST.getPredicate()));
        subtypeAssigner = new SubTypeAssignment(new SubType[]{SubType.SWAMP, SubType.FOREST});
    }
}

