/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class JaredCarthalionTrueHeirPreventionEffect
extends PreventionEffectImpl {
    JaredCarthalionTrueHeirPreventionEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "if damage would be dealt to {this} while you're the monarch, prevent that damage and put that many +1/+1 counters on it";
    }

    private JaredCarthalionTrueHeirPreventionEffect(JaredCarthalionTrueHeirPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public JaredCarthalionTrueHeirPreventionEffect copy() {
        return new JaredCarthalionTrueHeirPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getSourceId()) && source.isControlledBy(game.getMonarchId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(event.getAmount()), source.getControllerId(), source, game);
        }
        return super.replaceEvent(event, source, game);
    }
}

