/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class JawsRelentlessPredatorTriggeredAbility
extends TriggeredAbilityImpl {
    JawsRelentlessPredatorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(1, TargetController.OPPONENT));
        this.setTriggerPhrase("Whenever a noncreature artifact is sacrificed or destroyed, ");
    }

    private JawsRelentlessPredatorTriggeredAbility(JawsRelentlessPredatorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public JawsRelentlessPredatorTriggeredAbility copy() {
        return new JawsRelentlessPredatorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case SACRIFICED_PERMANENT: 
            case DESTROYED_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return permanent != null && !permanent.isCreature(game) && permanent.isArtifact(game);
    }
}

