/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class JeskasWillEffect
extends OneShotEffect {
    JeskasWillEffect() {
        super(Outcome.Benefit);
        this.staticText = "Add {R} for each card in target opponent's hand.";
    }

    private JeskasWillEffect(JeskasWillEffect effect) {
        super((OneShotEffect)effect);
    }

    public JeskasWillEffect copy() {
        return new JeskasWillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null || player.getHand().isEmpty()) {
            return false;
        }
        controller.getManaPool().addMana(Mana.RedMana((int)player.getHand().size()), game, source);
        return true;
    }
}

