/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class JestersScepterCounterEffect
extends OneShotEffect {
    JestersScepterCounterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if it has the same name as that card";
    }

    private JestersScepterCounterEffect(JestersScepterCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            String nameOfExiledCardPayment = (String)game.getState().getValue(source.getSourceId() + "_nameOfExiledCardPayment");
            String nameOfExiledCardPayment2 = (String)game.getState().getValue(source.getSourceId() + "_nameOfExiledCardPayment2");
            if (CardUtil.haveSameNames((MageObject)spell.getCard(), (String)nameOfExiledCardPayment, (Game)game) || CardUtil.haveSameNames((MageObject)spell.getCard(), (String)nameOfExiledCardPayment2, (Game)game)) {
                return game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
            }
        }
        return false;
    }

    public JestersScepterCounterEffect copy() {
        return new JestersScepterCounterEffect(this);
    }
}

