/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class JestersScepterEffect
extends OneShotEffect {
    JestersScepterEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile the top five cards of target player's library face down";
    }

    private JestersScepterEffect(JestersScepterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetedPlayer = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && targetedPlayer != null && sourceObject != null) {
            if (targetedPlayer.getLibrary().hasCards()) {
                Set cardsToExile = targetedPlayer.getLibrary().getTopCards(game, 5);
                for (Card card : cardsToExile) {
                    if (!card.moveToExile(CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceObject.getName(), source, game)) continue;
                    card.setFaceDown(true, game);
                }
            }
            return true;
        }
        return false;
    }

    public JestersScepterEffect copy() {
        return new JestersScepterEffect(this);
    }
}

