/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.stream.Stream;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.VariableCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.PowerstoneToken;
import mage.game.permanent.token.PowerstoneTokenManaBuilder;
import mage.players.Player;
import mage.util.CardUtil;

class JetfireIngeniousScientistEffect
extends OneShotEffect {
    JetfireIngeniousScientistEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player adds that much {C}. This mana can't be spent to cast nonartifact spells";
    }

    private JetfireIngeniousScientistEffect(JetfireIngeniousScientistEffect effect) {
        super((OneShotEffect)effect);
    }

    public JetfireIngeniousScientistEffect copy() {
        return new JetfireIngeniousScientistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        int countersRemoved = CardUtil.castStream((Stream)source.getCosts().stream(), VariableCost.class).mapToInt(VariableCost::getAmount).sum();
        if (player == null || countersRemoved < 1) {
            return false;
        }
        PowerstoneTokenManaBuilder manaBuilder = PowerstoneToken.makeBuilder();
        Mana mana = (Mana)manaBuilder.setMana(Mana.ColorlessMana((int)countersRemoved), source, game).build(new Object[0]);
        player.getManaPool().addMana(mana, game, source);
        return true;
    }
}

