/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.ManaPaidSourceWatcher;

class JetmirsFixerEffect
extends OneShotEffect {
    JetmirsFixerEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} gets +1/+1 until end of turn. If mana from a Treasure was spent to activate this ability, put a +1/+1 counter on {this} instead";
    }

    private JetmirsFixerEffect(JetmirsFixerEffect effect) {
        super((OneShotEffect)effect);
    }

    public JetmirsFixerEffect copy() {
        return new JetmirsFixerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (ManaPaidSourceWatcher.getTreasurePaid((UUID)source.getId(), (Game)game) < 1) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), source);
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
    }
}

