/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JhoirasTimebugEffect
extends OneShotEffect {
    JhoirasTimebugEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose target permanent you control or suspended card you own. If that permanent or card has a time counter on it, you may remove a time counter from it or put another time counter on it";
    }

    private JhoirasTimebugEffect(JhoirasTimebugEffect effect) {
        super((OneShotEffect)effect);
    }

    public JhoirasTimebugEffect copy() {
        return new JhoirasTimebugEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null && permanent.getCounters(game).containsKey(CounterType.TIME)) {
                if (controller.chooseUse(Outcome.Benefit, "Add a time counter? (Otherwise remove one)", source, game)) {
                    permanent.addCounters(CounterType.TIME.createInstance(), source.getControllerId(), source, game);
                } else {
                    permanent.removeCounters(CounterType.TIME.createInstance(), source, game);
                }
            } else {
                Card card = game.getExile().getCard(this.getTargetPointer().getFirst(game, source), game);
                if (card != null) {
                    if (controller.chooseUse(Outcome.Detriment, "Add a time counter? (Otherwise remove one)", source, game)) {
                        card.addCounters(CounterType.TIME.createInstance(), source.getControllerId(), source, game);
                    } else {
                        card.removeCounters(CounterType.TIME.createInstance(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

