/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInASingleGraveyard;

class JotunGruntCost
extends CostImpl {
    JotunGruntCost() {
        this.addTarget((Target)new TargetCardInASingleGraveyard(2, 2, new FilterCard()));
        this.text = "Put two cards from a single graveyard on the bottom of their owner's library";
    }

    private JotunGruntCost(JotunGruntCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null && this.getTargets().choose(Outcome.Removal, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null || game.getState().getZone(targetId) != Zone.GRAVEYARD) {
                    return false;
                }
                this.paid |= controller.moveCardToLibraryWithInfo(card, source, game, Zone.GRAVEYARD, false, true);
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public JotunGruntCost copy() {
        return new JotunGruntCost(this);
    }
}

