/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.WolfToken;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class JourneyToTheLostCityEffect
extends RollDieWithResultTableEffect {
    JourneyToTheLostCityEffect() {
        super(20, "exile the top four cards of your library, then roll a d20");
        this.addTableEntry(1, 9, new Effect[]{new InfoEffect("you may put a land card from among those cards onto the battlefield")});
        this.addTableEntry(10, 19, new Effect[]{new InfoEffect("create a 2/2 green Wolf creature token, then put a +1/+1 counter on it for each creature card among those cards")});
        this.addTableEntry(20, 20, new Effect[]{new InfoEffect("put all permanent cards exiled with {this} onto the battlefield, then sacrifice it")});
    }

    private JourneyToTheLostCityEffect(JourneyToTheLostCityEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public JourneyToTheLostCityEffect copy() {
        return new JourneyToTheLostCityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 4));
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        int amount = player.rollDice(this.outcome, source, game, 20);
        if (amount < 1) {
            return false;
        }
        if (amount <= 9) {
            TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND);
            target.withNotTarget(true);
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (amount <= 19) {
            WolfToken token = new WolfToken();
            token.putOntoBattlefield(1, game, source);
            int count = cards.count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            if (count > 0) {
                for (UUID tokenId : token.getLastAddedTokenIds()) {
                    Optional.ofNullable(game.getPermanent(tokenId)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(count), source, game));
                }
            }
            return true;
        }
        if (amount != 20) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone != null && !exileZone.isEmpty()) {
            player.moveCards(exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_PERMANENT, game), Zone.BATTLEFIELD, source, game);
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> permanent.sacrifice(source, game));
        return true;
    }
}

