/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class JourneyToTheOracleEffect
extends OneShotEffect {
    JourneyToTheOracleEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put any number of land cards from your hand onto the battlefield";
    }

    private JourneyToTheOracleEffect(JourneyToTheOracleEffect effect) {
        super((OneShotEffect)effect);
    }

    public JourneyToTheOracleEffect copy() {
        return new JourneyToTheOracleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        player.choose(Outcome.PutCardInPlay, (Target)target, source, game);
        return player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
    }
}

