/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class JungleWayfinderEffect
extends OneShotEffect {
    JungleWayfinderEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may search their library for a basic land card, reveal it, put it into their hand, then shuffle";
    }

    private JungleWayfinderEffect(JungleWayfinderEffect effect) {
        super((OneShotEffect)effect);
    }

    public JungleWayfinderEffect copy() {
        return new JungleWayfinderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
                if (!player.chooseUse(Outcome.Benefit, "Search your library for a card to put into your hand?", source, game)) continue;
                player.searchLibrary(target, source, game);
                for (UUID cardId : target.getTargets()) {
                    Card card = player.getLibrary().getCard(cardId, game);
                    if (card == null) continue;
                    player.revealCards(source, (Cards)new CardsImpl(card), game);
                    player.moveCards(card, Zone.HAND, source, game);
                }
                player.shuffleLibrary(source, game);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

