/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JunkJetAbility
extends OneShotEffect {
    JunkJetAbility() {
        super(Outcome.BoostCreature);
        this.staticText = "Double equipped creature's power until end of turn";
    }

    private JunkJetAbility(JunkJetAbility effect) {
        super((OneShotEffect)effect);
    }

    public JunkJetAbility copy() {
        return new JunkJetAbility(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipment = source.getSourcePermanentOrLKI(game);
        if (equipment == null) {
            return false;
        }
        Permanent equippedCreature = game.getPermanent(equipment.getAttachedTo());
        if (equippedCreature == null) {
            return false;
        }
        ContinuousEffect boost = new BoostTargetEffect(equippedCreature.getPower().getValue(), 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(equippedCreature, game));
        game.addEffect(boost, source);
        return true;
    }
}

