/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class JuxtaposeEffect
extends ContinuousEffectImpl {
    private final FilterPermanent filter;
    private final Map<UUID, Integer> zoneChangeCounter;
    private final Map<UUID, UUID> lockedControllers;

    public JuxtaposeEffect(FilterPermanent filter, String text) {
        super(Duration.EndOfGame, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = text;
        this.filter = filter;
        this.zoneChangeCounter = new HashMap<UUID, Integer>();
        this.lockedControllers = new HashMap<UUID, UUID>();
    }

    private JuxtaposeEffect(JuxtaposeEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.filter = effect.filter.copy();
        this.zoneChangeCounter = new HashMap<UUID, Integer>(effect.zoneChangeCounter);
        this.lockedControllers = new HashMap<UUID, UUID>(effect.lockedControllers);
    }

    public JuxtaposeEffect copy() {
        return new JuxtaposeEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (you != null && targetPlayer != null) {
            Permanent permanent1 = this.chooseOnePermanentsWithTheHighestCMC(you, this.filter, source, game);
            Permanent permanent2 = this.chooseOnePermanentsWithTheHighestCMC(targetPlayer, this.filter, source, game);
            if (permanent1 != null && permanent2 != null) {
                if (permanent1.isControlledBy(permanent2.getControllerId())) {
                    this.discard();
                    return;
                }
                this.lockedControllers.put(permanent1.getId(), permanent2.getControllerId());
                this.zoneChangeCounter.put(permanent1.getId(), permanent1.getZoneChangeCounter(game));
                this.lockedControllers.put(permanent2.getId(), permanent1.getControllerId());
                this.zoneChangeCounter.put(permanent2.getId(), permanent2.getZoneChangeCounter(game));
                permanent1.changeControllerId(targetPlayer.getId(), game, source);
                permanent2.changeControllerId(you.getId(), game, source);
                Card sourceObject = game.getCard(source.getSourceId());
                game.informPlayers((sourceObject != null ? sourceObject.getLogName() : "") + ": " + you.getLogName() + " and " + targetPlayer.getLogName() + " exchange control of " + permanent1.getLogName() + " and " + permanent2.getName());
            } else {
                this.discard();
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> toDelete = new HashSet<UUID>();
        for (Map.Entry<UUID, Integer> entry : this.zoneChangeCounter.entrySet()) {
            Permanent permanent = game.getPermanent(entry.getKey());
            if (permanent == null || permanent.getZoneChangeCounter(game) != entry.getValue().intValue()) {
                toDelete.add(entry.getKey());
                continue;
            }
            permanent.changeControllerId(this.lockedControllers.get(permanent.getId()), game, source);
        }
        if (!toDelete.isEmpty()) {
            for (UUID uuid : toDelete) {
                this.zoneChangeCounter.remove(uuid);
            }
            if (this.zoneChangeCounter.isEmpty()) {
                this.discard();
                return false;
            }
        }
        return true;
    }

    private Permanent chooseOnePermanentsWithTheHighestCMC(Player player, FilterPermanent filter, Ability source, Game game) {
        List<Permanent> permanents = this.getPermanentsWithTheHighestCMC(player.getId(), filter, source, game);
        return this.chooseOnePermanent(player, permanents, source, game);
    }

    private List<Permanent> getPermanentsWithTheHighestCMC(UUID playerId, FilterPermanent filter, Ability source, Game game) {
        List permanents = game.getBattlefield().getAllActivePermanents(filter, playerId, game);
        int highestCMC = -1;
        for (Permanent permanent : permanents) {
            if (highestCMC >= permanent.getManaValue()) continue;
            highestCMC = permanent.getManaValue();
        }
        ArrayList<Permanent> result = new ArrayList<Permanent>();
        for (Permanent permanent : permanents) {
            if (permanent.getManaValue() != highestCMC) continue;
            result.add(permanent);
        }
        return result;
    }

    private Permanent chooseOnePermanent(Player player, List<Permanent> permanents, Ability source, Game game) {
        Permanent permanent = null;
        if (permanents.size() == 1) {
            permanent = permanents.iterator().next();
        } else if (permanents.size() > 1) {
            CardsImpl cards = new CardsImpl();
            for (Permanent card : permanents) {
                cards.add((Card)card);
            }
            TargetCard targetCard = new TargetCard(Zone.BATTLEFIELD, new FilterCard());
            if (player.choose(Outcome.Benefit, (Cards)cards, targetCard, source, game)) {
                permanent = game.getPermanent(targetCard.getFirstTarget());
            }
        }
        return permanent;
    }
}

