/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CantBeBlockedByCreaturesWithLessPowerEffect
extends RestrictionEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Islands");
    private final DynamicValue dynamicValue = new PermanentsOnBattlefieldCount((FilterPermanent)filter);

    public CantBeBlockedByCreaturesWithLessPowerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with power less than the number of Islands you control can't block {this}";
    }

    private CantBeBlockedByCreaturesWithLessPowerEffect(CantBeBlockedByCreaturesWithLessPowerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() >= this.dynamicValue.calculate(game, source, (Effect)this);
    }

    public CantBeBlockedByCreaturesWithLessPowerEffect copy() {
        return new CantBeBlockedByCreaturesWithLessPowerEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

