/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.Target;
import mage.util.CardUtil;

class KaerveksTorchCostIncreaseEffect
extends CostModificationEffectImpl {
    KaerveksTorchCostIncreaseEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "As long as {this} is on the stack, spells that target it cost {2} more to cast";
    }

    private KaerveksTorchCostIncreaseEffect(KaerveksTorchCostIncreaseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility) {
            for (UUID modeId : abilityToModify.getModes().getSelectedModes()) {
                Mode mode = abilityToModify.getModes().get((Object)modeId);
                for (Target target : mode.getTargets()) {
                    for (UUID targetId : target.getTargets()) {
                        if (!targetId.equals(source.getSourceObject(game).getId())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public KaerveksTorchCostIncreaseEffect copy() {
        return new KaerveksTorchCostIncreaseEffect(this);
    }
}

