/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.k.KaghaShadowArchdruidWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KaghaShadowArchdruidEffect
extends AsThoughEffectImpl {
    KaghaShadowArchdruidEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once during each of your turns, you may play a land or cast a permanent spell from among cards in your graveyard that were put there from your library this turn.";
    }

    private KaghaShadowArchdruidEffect(KaghaShadowArchdruidEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public KaghaShadowArchdruidEffect copy() {
        return new KaghaShadowArchdruidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (source.isControlledBy(affectedControllerId) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(objectId)) && game.isActivePlayer(affectedControllerId)) {
            Card card = game.getCard(objectId);
            Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
            KaghaShadowArchdruidWatcher watcher = (KaghaShadowArchdruidWatcher)game.getState().getWatcher(KaghaShadowArchdruidWatcher.class);
            if (card != null && sourceObject != null && card.isOwnedBy(affectedControllerId) && card.isPermanent(game) && watcher != null && watcher.checkCard(card, game)) {
                return watcher.abilityNotUsed(new MageObjectReference((MageObject)sourceObject, game));
            }
        }
        return false;
    }
}

