/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mage.abilities.keyword.CompanionCondition;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SubType;

enum KaheeraTheOrphanguardCompanionCondition implements CompanionCondition
{
    instance;

    private static final List<SubType> subtypes;

    public String getRule() {
        return "Each creature card in your starting deck is a Cat, Elemental, Nightmare, Dinosaur, or Beast card.";
    }

    private static boolean isCardLegal(Card card) {
        return subtypes.stream().anyMatch(arg_0 -> ((Card)card).hasSubTypeForDeckbuilding(arg_0));
    }

    public boolean isLegal(Set<Card> deck, int minimumDeckSize) {
        return deck.stream().filter(card -> card.hasCardTypeForDeckbuilding(CardType.CREATURE)).allMatch(KaheeraTheOrphanguardCompanionCondition::isCardLegal);
    }

    static {
        subtypes = Arrays.asList(SubType.CAT, SubType.ELEMENTAL, SubType.NIGHTMARE, SubType.DINOSAUR, SubType.BEAST);
    }
}

