/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.common.ManaPaidSourceWatcher;

class KalainReclusivePainterEffect
extends ReplacementEffectImpl {
    KalainReclusivePainterEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "other creatures you control enter the battlefield with an additional +1/+1 counter on them for each mana from a Treasure spent to cast them";
    }

    private KalainReclusivePainterEffect(KalainReclusivePainterEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        return creature != null && !creature.getId().equals(source.getSourceId()) && creature.isControlledBy(source.getControllerId()) && creature.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature == null) {
            return false;
        }
        int manaPaid = ManaPaidSourceWatcher.getTreasurePaid((UUID)creature.getId(), (Game)game);
        if (manaPaid < 1) {
            return false;
        }
        creature.addCounters(CounterType.P1P1.createInstance(manaPaid), source.getControllerId(), source, game, event.getAppliedEffects());
        return false;
    }

    public KalainReclusivePainterEffect copy() {
        return new KalainReclusivePainterEffect(this);
    }
}

