/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.KalitasVampireToken;
import mage.game.permanent.token.Token;

class KalitasDestroyEffect
extends OneShotEffect {
    KalitasDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. If that creature dies this way, create a black Vampire creature token. Its power is equal to that creature's power and its toughness is equal to that creature's toughness";
    }

    private KalitasDestroyEffect(KalitasDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public KalitasDestroyEffect copy() {
        return new KalitasDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.destroy(source, game, false)) {
            if (permanent.getZoneChangeCounter(game) + 1 == game.getState().getZoneChangeCounter(permanent.getId()) && game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) {
                return true;
            }
            new CreateTokenEffect((Token)new KalitasVampireToken(permanent.getPower().getValue(), permanent.getToughness().getValue())).apply(game, source);
        }
        return true;
    }
}

