/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class KamahlsDruidicVowEffect
extends OneShotEffect {
    KamahlsDruidicVowEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Look at the top X cards of your library. You may put any number of land and/or legendary permanent cards with mana value X or less from among them onto the battlefield. Put the rest into your graveyard";
    }

    private KamahlsDruidicVowEffect(KamahlsDruidicVowEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        controller.lookAtCards(source, null, (Cards)cards, game);
        if (!cards.isEmpty()) {
            FilterPermanentCard filter = new FilterPermanentCard("land and/or legendary permanent cards with mana value " + xValue + " or less to put onto the battlefield");
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
            filter.add(Predicates.or((Predicate)CardType.LAND.getPredicate(), (Predicate)SuperType.LEGENDARY.getPredicate()));
            TargetCard target1 = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, (FilterCard)filter);
            target1.withNotTarget(true);
            controller.choose(Outcome.PutCardInPlay, (Cards)cards, target1, source, game);
            CardsImpl toBattlefield = new CardsImpl((Collection)target1.getTargets());
            cards.removeAll((Collection)toBattlefield);
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, false, null);
            controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }

    public KamahlsDruidicVowEffect copy() {
        return new KamahlsDruidicVowEffect(this);
    }
}

