/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class KamahlsWillEffect
extends OneShotEffect {
    KamahlsWillEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you don't control. Each creature you control deals damage equal to its power to that creature";
    }

    private KamahlsWillEffect(KamahlsWillEffect effect) {
        super((OneShotEffect)effect);
    }

    public KamahlsWillEffect copy() {
        return new KamahlsWillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (creature == null || creature.getPower().getValue() < 1) continue;
            permanent.damage(creature.getPower().getValue(), creature.getId(), source, game);
        }
        return true;
    }
}

