/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.k.KambalProfiteeringMayorEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeBatchEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class KambalProfiteeringMayorTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<ZoneChangeEvent> {
    KambalProfiteeringMayorTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.setTriggersLimitEachTurn(1);
    }

    private KambalProfiteeringMayorTriggeredAbility(KambalProfiteeringMayorTriggeredAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public KambalProfiteeringMayorTriggeredAbility copy() {
        return new KambalProfiteeringMayorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_BATCH;
    }

    public boolean checkEvent(ZoneChangeEvent event, Game game) {
        if (event.getToZone() != Zone.BATTLEFIELD) {
            return false;
        }
        if (!game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = event.getTarget();
        return permanent instanceof PermanentToken;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        List<UUID> tokensIds = this.getFilteredEvents((BatchEvent)((ZoneChangeBatchEvent)event), game).stream().map(ZoneChangeEvent::getTarget).map(MageItem::getId).collect(Collectors.toList());
        if (tokensIds.isEmpty()) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new KambalProfiteeringMayorEffect(tokensIds));
        return true;
    }

    public String getRule() {
        return "Whenever one or more tokens your opponents control enter, for each of them, create a tapped token that's a copy of it. This ability triggers only once each turn.";
    }
}

