/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KamisFlareEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent();
    private static final Hint hint;

    KamisFlareEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to target creature or planeswalker. {this} also deals 2 damage to that permanent's controller if you control a modified creature";
    }

    private KamisFlareEffect(KamisFlareEffect effect) {
        super((OneShotEffect)effect);
    }

    public KamisFlareEffect copy() {
        return new KamisFlareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(3, source, game);
        if (!game.getBattlefield().contains(filter, source, game, 1)) {
            return true;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(2, source, game);
        }
        return true;
    }

    public static Hint getHint() {
        return hint;
    }

    static {
        filter.add((Predicate)ModifiedPredicate.instance);
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        hint = new ConditionHint((Condition)new PermanentsOnTheBattlefieldCondition(filter), "You control a modified creature");
    }
}

