/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.cost.CastFromHandForFreeEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class KariZevsExpertise
extends CardImpl {
    private static final FilterCard filter = new FilterCard("a spell with mana value 2 or less");

    public KariZevsExpertise(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{R}{R}");
        this.getSpellAbility().addTarget((Target)new TargetPermanent(StaticFilters.FILTER_PERMANENT_CREATURE_OR_VEHICLE));
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect().setText("Untap it"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("It gains haste until end of turn"));
        this.getSpellAbility().addEffect((Effect)new CastFromHandForFreeEffect(filter).concatBy("<br>"));
    }

    private KariZevsExpertise(KariZevsExpertise card) {
        super((CardImpl)card);
    }

    public KariZevsExpertise copy() {
        return new KariZevsExpertise(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

