/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class KasminaEnigmaSageSearchEffect
extends OneShotEffect {
    KasminaEnigmaSageSearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for an instant or sorcery card that shares a color with this planeswalker, exile that card, then shuffle. You may cast that card without paying its mana cost.";
    }

    private KasminaEnigmaSageSearchEffect(KasminaEnigmaSageSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public KasminaEnigmaSageSearchEffect copy() {
        return new KasminaEnigmaSageSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (controller == null || permanent == null) {
            return false;
        }
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("an instant, or sorcery card which shares a color with " + permanent.getLogName());
        filter.add((Predicate)new SharesColorPredicate(permanent.getColor(game)));
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        controller.searchLibrary(target, source, game);
        Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        controller.shuffleLibrary(source, game);
        if (card == null || !controller.chooseUse(Outcome.PlayForFree, "Cast " + card.getName() + " without paying its mana cost?", source, game)) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        Boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(card, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        return true;
    }
}

