/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KataraTheFearlessEffect
extends ReplacementEffectImpl {
    KataraTheFearlessEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a triggered ability of an Ally you control triggers, that ability triggers an additional time";
    }

    private KataraTheFearlessEffect(KataraTheFearlessEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public KataraTheFearlessEffect copy() {
        return new KataraTheFearlessEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.hasSubtype(SubType.ALLY, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

