/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KatildaDawnhartPrimeManaEffect
extends ManaEffect {
    KatildaDawnhartPrimeManaEffect() {
        this.staticText = "Add one mana of any of this creature's colors";
    }

    private KatildaDawnhartPrimeManaEffect(KatildaDawnhartPrimeManaEffect effect) {
        super((ManaEffect)effect);
    }

    public KatildaDawnhartPrimeManaEffect copy() {
        return new KatildaDawnhartPrimeManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game == null) {
            return new ArrayList<Mana>();
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return new ArrayList<Mana>();
        }
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        ObjectColor color = permanent.getColor(game);
        if (color.isWhite()) {
            netMana.add(Mana.WhiteMana((int)1));
        }
        if (color.isBlue()) {
            netMana.add(Mana.BlueMana((int)1));
        }
        if (color.isBlack()) {
            netMana.add(Mana.BlackMana((int)1));
        }
        if (color.isRed()) {
            netMana.add(Mana.RedMana((int)1));
        }
        if (color.isGreen()) {
            netMana.add(Mana.GreenMana((int)1));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return new Mana();
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || permanent == null) {
            return new Mana();
        }
        ChoiceImpl choice = new ChoiceImpl(false).setManaColorChoice(true);
        choice.setMessage("Pick a mana color");
        ObjectColor color = permanent.getColor(game);
        if (color.isWhite()) {
            choice.getChoices().add("White");
        }
        if (color.isBlue()) {
            choice.getChoices().add("Blue");
        }
        if (color.isBlack()) {
            choice.getChoices().add("Black");
        }
        if (color.isRed()) {
            choice.getChoices().add("Red");
        }
        if (color.isGreen()) {
            choice.getChoices().add("Green");
        }
        if (choice.getChoices().isEmpty()) {
            return new Mana();
        }
        if (choice.getChoices().size() == 1) {
            choice.setChoice((String)choice.getChoices().iterator().next());
        } else {
            controller.choose(Outcome.PutManaInPool, (Choice)choice, game);
        }
        if (choice.getChoice() == null) {
            return new Mana();
        }
        switch (choice.getChoice()) {
            case "White": {
                return Mana.WhiteMana((int)1);
            }
            case "Blue": {
                return Mana.BlueMana((int)1);
            }
            case "Black": {
                return Mana.BlackMana((int)1);
            }
            case "Red": {
                return Mana.RedMana((int)1);
            }
            case "Green": {
                return Mana.GreenMana((int)1);
            }
        }
        return new Mana();
    }
}

