/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class KayaOrzhovUsurperDamageEffect
extends OneShotEffect {
    KayaOrzhovUsurperDamageEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to target player equal to the number of cards that player owns in exile and you gain that much life.";
    }

    private KayaOrzhovUsurperDamageEffect(KayaOrzhovUsurperDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public KayaOrzhovUsurperDamageEffect copy() {
        return new KayaOrzhovUsurperDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        int count = game.getExile().getCardsOwned(game, player.getId()).size();
        player.damage(count, source.getSourceId(), source, game);
        controller.gainLife(count, game, source);
        return true;
    }
}

