/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetadjustment.TargetAdjuster;

enum KayaSpiritsJusticeAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        ability.getTargets().clear();
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller == null) {
            return;
        }
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE));
        for (UUID playerId : game.getState().getPlayersInRange(ability.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player == controller) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature that player controls");
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            ability.addTarget(new TargetPermanent(0, 1, (FilterPermanent)filter).withChooseHint("from " + player.getLogName()));
        }
    }
}

