/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class KayaTheInexorableEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    KayaTheInexorableEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private KayaTheInexorableEffect(KayaTheInexorableEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public KayaTheInexorableEffect copy() {
        return new KayaTheInexorableEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = game.getCard(this.mor.getSourceId());
        if (card == null || card.getZoneChangeCounter(game) - 1 != this.mor.getZoneChangeCounter()) {
            return false;
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

