/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KaylasCommandCounterEffect
extends OneShotEffect {
    KaylasCommandCounterEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put a +1/+1 counter on a creature you control. It gains double strike until end of turn.";
    }

    private KaylasCommandCounterEffect(KaylasCommandCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaylasCommandCounterEffect copy() {
        return new KaylasCommandCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance());
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

