/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetDiscard;

class KefkaCourtMageEffect
extends OneShotEffect {
    KefkaCourtMageEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player discards a card. Then you draw a card for each card type among cards discarded this way";
    }

    private KefkaCourtMageEffect(KefkaCourtMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public KefkaCourtMageEffect copy() {
        return new KefkaCourtMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<Object, Card> map = new HashMap<Object, Card>();
        block4: for (Object playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player2 = game.getPlayer((UUID)playerId);
            if (player2 == null) continue;
            switch (player2.getHand().size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    map.put(playerId, player2.getHand().getRandom(game));
                    continue block4;
                }
            }
            TargetDiscard target = new TargetDiscard((UUID)playerId);
            player2.choose(this.outcome, player2.getHand(), (TargetCard)target, source, game);
            map.put(playerId, game.getCard(target.getFirstTarget()));
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player3 = game.getPlayer(playerId);
            Card card2 = map.getOrDefault(playerId, null);
            if (player3 == null || card2 == null || !player3.discard(card2, false, source, game)) continue;
            cards.add(card2);
        }
        if (cards.isEmpty()) {
            return false;
        }
        int count = cards.getCards(game).stream().map(card -> card.getCardType(game)).flatMap(Collection::stream).distinct().mapToInt(x -> 1).sum();
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(count, source, game));
        return true;
    }
}

