/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KefnetTheMindfulRestrictionEffect
extends RestrictionEffect {
    KefnetTheMindfulRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless you have seven or more cards in your hand";
    }

    private KefnetTheMindfulRestrictionEffect(KefnetTheMindfulRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public KefnetTheMindfulRestrictionEffect copy() {
        return new KefnetTheMindfulRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                return controller.getHand().size() < 7;
            }
            return true;
        }
        return false;
    }
}

