/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.AdditiveDynamicValue;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.AuraAttachedCount;
import mage.abilities.dynamicvalue.common.EquipmentAttachedCount;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.cards.AdventureCard;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.common.TargetCardInLibrary;

public final class KellanTheFaeBlooded
extends AdventureCard {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures you control");
    private static final FilterCard auraOrEquipmentCard = new FilterCard("Aura or Equipment card");

    public KellanTheFaeBlooded(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, new CardType[]{CardType.SORCERY}, "{2}{R}", "Birthright Boon", "{1}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.FAERIE);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)DoubleStrikeAbility.getInstance());
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostControlledEffect((DynamicValue)new AdditiveDynamicValue(new DynamicValue[]{new AuraAttachedCount(), new EquipmentAttachedCount()}), (DynamicValue)StaticValue.get((int)0), Duration.WhileOnBattlefield, (FilterPermanent)filter, true).setText("Other creatures you control get +1/+0 for each Aura and Equipment attached to {this}.")));
        this.getSpellCard().getSpellAbility().addEffect((Effect)new SearchLibraryPutInHandEffect(new TargetCardInLibrary(auraOrEquipmentCard), true));
        this.finalizeAdventure();
    }

    private KellanTheFaeBlooded(KellanTheFaeBlooded card) {
        super((AdventureCard)card);
    }

    public KellanTheFaeBlooded copy() {
        return new KellanTheFaeBlooded(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        auraOrEquipmentCard.add(Predicates.or((Predicate)SubType.EQUIPMENT.getPredicate(), (Predicate)SubType.AURA.getPredicate()));
    }
}

