/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.DynamicCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.k.ColorlessManaValue;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class KentaroTheSmilingCatCastingEffect
extends ContinuousEffectImpl {
    private static final FilterCard filterSamurai = new FilterCard();
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Condition)SourceIsSpellCondition.instance, null, filterSamurai, true, (DynamicCost)new ColorlessManaValue());

    public KentaroTheSmilingCatCastingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may pay {X} rather than pay the mana cost for Samurai spells you cast, where X is that spell's mana value";
    }

    private KentaroTheSmilingCatCastingEffect(KentaroTheSmilingCatCastingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public KentaroTheSmilingCatCastingEffect copy() {
        return new KentaroTheSmilingCatCastingEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }

    static {
        filterSamurai.add((Predicate)SubType.SAMURAI.getPredicate());
    }
}

