/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class KessDissidentMageWatcher
extends Watcher {
    private final Set<MageObjectReference> allowingObjects = new HashSet<MageObjectReference>();
    private final Map<MageObjectReference, UUID> castSpells = new HashMap<MageObjectReference, UUID>();

    KessDissidentMageWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (GameEvent.EventType.SPELL_CAST.equals((Object)event.getType()) && event.hasApprovingIdentifier(MageIdentifier.KessDissidentMageWatcher) && (spell = (Spell)game.getObject(event.getTargetId())) != null) {
            this.allowingObjects.add(event.getApprovingObject().getApprovingMageObjectReference());
            this.castSpells.put(new MageObjectReference(spell.getMainCard().getId(), game), event.getApprovingObject().getApprovingAbility().getSourceId());
        }
    }

    public void reset() {
        super.reset();
        this.allowingObjects.clear();
    }

    public boolean isAbilityUsed(MageObjectReference mor) {
        return this.allowingObjects.contains(mor);
    }

    public UUID spellCastWasAllowedBy(MageObjectReference mor) {
        return this.castSpells.getOrDefault(mor, null);
    }
}

