/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.WolfToken;
import mage.players.Player;

class KessigCagebreakersEffect
extends OneShotEffect {
    KessigCagebreakersEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 2/2 green Wolf creature token that's tapped and attacking for each creature card in your graveyard";
    }

    private KessigCagebreakersEffect(KessigCagebreakersEffect effect) {
        super((OneShotEffect)effect);
    }

    public KessigCagebreakersEffect copy() {
        return new KessigCagebreakersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            WolfToken token = new WolfToken();
            int count = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            for (int i = 0; i < count; ++i) {
                token.putOntoBattlefield(1, game, source, source.getControllerId(), true, true);
            }
            return true;
        }
        return false;
    }
}

