/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.replacement.LeaveBattlefieldExileTargetReplacementEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class KheruLichLordEffect
extends OneShotEffect {
    KheruLichLordEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a creature card at random from your graveyard to the battlefield. It gains flying, trample, and haste. Exile that card at the beginning of the next end step. If that card would leave the battlefield, exile it instead of putting it anywhere else";
    }

    private KheruLichLordEffect(KheruLichLordEffect effect) {
        super((OneShotEffect)effect);
    }

    public KheruLichLordEffect copy() {
        return new KheruLichLordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, source.getControllerId(), source, game));
            Card card = cards.getRandom(game);
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                if (permanent != null) {
                    FixedTarget blueprintTarget = new FixedTarget(permanent, game);
                    GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    game.addEffect((ContinuousEffect)effect, source);
                    effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    game.addEffect((ContinuousEffect)effect, source);
                    effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                    effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    game.addEffect((ContinuousEffect)effect, source);
                    ExileTargetEffect exileEffect = new ExileTargetEffect();
                    exileEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                    LeaveBattlefieldExileTargetReplacementEffect replacementEffect = new LeaveBattlefieldExileTargetReplacementEffect("that card");
                    replacementEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                    game.addEffect((ContinuousEffect)replacementEffect, source);
                }
            }
            return true;
        }
        return false;
    }
}

