/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class KheruMindEaterExileEffect
extends OneShotEffect {
    KheruMindEaterExileEffect() {
        super(Outcome.Discard);
        this.staticText = "that player exiles a card of their hand face down";
    }

    private KheruMindEaterExileEffect(KheruMindEaterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && !player.getHand().isEmpty()) {
            TargetCardInHand target = new TargetCardInHand(1, new FilterCard());
            target.chooseTarget(Outcome.Exile, player.getId(), source, game);
            Card card = game.getCard(target.getFirstTarget());
            MageObject sourceObject = game.getObject(source);
            if (card != null && sourceObject != null) {
                if (player.moveCardsToExile(card, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceObject.getIdName())) {
                    card.setFaceDown(true, game);
                }
                return true;
            }
        }
        return false;
    }

    public KheruMindEaterExileEffect copy() {
        return new KheruMindEaterExileEffect(this);
    }
}

