/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.stack.StackObject;

class KheruSpellsnatcherEffect
extends OneShotEffect {
    KheruSpellsnatcherEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. If that spell is countered this way, exile it instead of putting it into its owner's graveyard. You may cast that card without paying its mana cost for as long as it remains exiled";
    }

    private KheruSpellsnatcherEffect(KheruSpellsnatcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public KheruSpellsnatcherEffect copy() {
        return new KheruSpellsnatcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject card;
        MageObject sourceObject = source.getSourceObject(game);
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject != null && sourceObject != null && game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game, PutCards.EXILED) && !stackObject.isCopy() && (card = game.getObject(stackObject.getSourceId())) instanceof Card) {
            return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)((Card)card), (TargetController)TargetController.YOU, (Duration)Duration.Custom, (boolean)true, (boolean)false, (boolean)true);
        }
        return false;
    }
}

