/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.k.KillSwitchUntapEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class KillSwitchEffect
extends OneShotEffect {
    KillSwitchEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap all other artifacts. They don't untap during their controllers' untap steps for as long as {this} remains tapped";
    }

    private KillSwitchEffect(KillSwitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public KillSwitchEffect copy() {
        return new KillSwitchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT, source.getControllerId(), source, game);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            permanents.remove(sourcePermanent);
            game.addEffect(new KillSwitchUntapEffect().setTargetPointer((TargetPointer)new FixedTargets((Collection)permanents, game)), source);
        }
        for (Permanent permanent : permanents) {
            permanent.tap(source, game);
        }
        return true;
    }
}

