/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KillSwitchUntapEffect
extends ContinuousRuleModifyingEffectImpl {
    KillSwitchUntapEffect() {
        super(Duration.Custom, Outcome.Detriment);
    }

    private KillSwitchUntapEffect(KillSwitchUntapEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public KillSwitchUntapEffect copy() {
        return new KillSwitchUntapEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getTurnStepType() != PhaseStep.UNTAP) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null || !sourcePermanent.isTapped()) {
            this.discard();
            return false;
        }
        return this.getTargetPointer().getTargets(game, source).contains(event.getTargetId()) && game.isActivePlayer(game.getControllerId(event.getTargetId()));
    }
}

