/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class KillerInstinctEffect
extends OneShotEffect {
    KillerInstinctEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal the top card of your library. If it's a creature card, put it onto the battlefield. That creature gains haste until end of turn. Sacrifice it at the beginning of the next end step.";
    }

    private KillerInstinctEffect(KillerInstinctEffect effect) {
        super((OneShotEffect)effect);
    }

    public KillerInstinctEffect copy() {
        return new KillerInstinctEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObjectIfItStillExists(game);
        if (player == null || sourceObject == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (library == null || !library.hasCards()) {
            return false;
        }
        Card card = library.getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
        if (card.isCreature(game) && player.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null) {
                FixedTarget blueprintTarget = new FixedTarget(permanent, game);
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                game.addEffect((ContinuousEffect)effect, source);
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("Sacrifice it at the beginning of the next end step", source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect), source);
            }
            return true;
        }
        return false;
    }
}

