/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class KillianInkDuelistEffect
extends CostModificationEffectImpl {
    KillianInkDuelistEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.REDUCE_COST);
        this.staticText = "spells you cast that target a creature cost {2} less to cast";
    }

    private KillianInkDuelistEffect(KillianInkDuelistEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public KillianInkDuelistEffect copy() {
        return new KillianInkDuelistEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (game.inCheckPlayableState()) {
            if (CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.isCreature(game))) {
                CardUtil.reduceCost((Ability)abilityToModify, (int)2);
            }
        } else if (CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.isCreature(game))) {
            CardUtil.reduceCost((Ability)abilityToModify, (int)2);
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId());
    }
}

