/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.k.KimahriValiantGuardian;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class KimahriValiantGuardianEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
            blueprint.setName("Kimahri, Valiant Guardian");
            blueprint.getAbilities().add((Object)VigilanceAbility.getInstance());
            blueprint.getAbilities().add((Object)KimahriValiantGuardian.makeAbility());
            return true;
        }
    };

    KimahriValiantGuardianEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may have {this} become a copy of that creature, except its name is Kimahri, Valiant Guardian and it has vigilance and this ability.";
    }

    private KimahriValiantGuardianEffect(KimahriValiantGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public KimahriValiantGuardianEffect copy() {
        return new KimahriValiantGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return player != null && permanent != null && creature != null && player.chooseUse(Outcome.Copy, "Have " + permanent.getIdName() + " become a copy of " + creature.getIdName() + '?', source, game) && game.copyPermanent(Duration.Custom, creature, permanent.getId(), source, applier) != null;
    }
}

