/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;

class KindleCardsInAllGraveyardsCount
implements DynamicValue {
    private final FilterCard filter;

    public KindleCardsInAllGraveyardsCount(FilterCard filter) {
        this.filter = filter;
    }

    private KindleCardsInAllGraveyardsCount(KindleCardsInAllGraveyardsCount dynamicValue) {
        this.filter = dynamicValue.filter;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int amount = 0;
        PlayerList playerList = game.getPlayerList().copy();
        for (UUID playerUUID : playerList) {
            Player player = game.getPlayer(playerUUID);
            if (player == null) continue;
            amount += player.getGraveyard().count(this.filter, sourceAbility.getControllerId(), sourceAbility, game);
        }
        return amount + 2;
    }

    public KindleCardsInAllGraveyardsCount copy() {
        return new KindleCardsInAllGraveyardsCount(this);
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return this.filter.getMessage() + " in all graveyards";
    }
}

