/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class KindleTheCarnageEffect
extends OneShotEffect {
    KindleTheCarnageEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Discard a card at random. If you do, {this} deals damage equal to that card's mana value to each creature. You may repeat this process any number of times";
    }

    private KindleTheCarnageEffect(KindleTheCarnageEffect effect) {
        super((OneShotEffect)effect);
    }

    public KindleTheCarnageEffect copy() {
        return new KindleTheCarnageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Cards hand = controller.getHand();
            while (hand != null && hand.size() > 0 && controller.chooseUse(Outcome.AIDontUseIt, "Discard a card randomly from your hand?", source, game)) {
                Card discardedCard = controller.discardOne(true, false, source, game);
                if (discardedCard == null) continue;
                new DamageAllEffect(discardedCard.getManaValue(), (FilterPermanent)new FilterCreaturePermanent()).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

