/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class KindredDenialEffect
extends OneShotEffect {
    KindredDenialEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. Seek a card with the same mana value as that spell";
    }

    private KindredDenialEffect(KindredDenialEffect effect) {
        super((OneShotEffect)effect);
    }

    public KindredDenialEffect copy() {
        return new KindredDenialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = game.getSpell(source.getFirstTarget());
        if (player == null || spell == null) {
            return false;
        }
        int manaValue = spell.getManaValue();
        game.getStack().counter(spell.getId(), source, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, manaValue));
        player.seekCard(filter, source, game);
        return true;
    }
}

